///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 *	This file contains the light-related exported structures.
 *	\file		FLX_AddLight.h
 *	\author		Pierre Terdiman
 *	\date		April, 4, 2000
 */
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Include Guard
#ifndef __FLX_ADDLIGHT_H__
#define __FLX_ADDLIGHT_H__

	//! Light types from MAX. Usual rendering APIs only keep Point, Spot and Directional lights.
	enum LType
	{
		LTYPE_OMNI		= 0,						//!< Omnidirectional		(PointLight)
		LTYPE_TSPOT		= 1,						//!< Targeted				(SpotLight)
		LTYPE_DIR		= 2,						//!< Directional			(DirectionalLight)
		LTYPE_FSPOT		= 3,						//!< Free					(SpotLight)
		LTYPE_TDIR		= 4							//!< Targeted directional	(DirectionalLight)
	};

	//! Spotlight shape.
	enum SpotShp
	{
		SPOTSHP_RECT	= 0,						//!< Rectangle.
		SPOTSHP_CIRCLE	= 1							//!< Circle.
	};

	//! Decay type
	enum DecayType
	{
		DECAYTYPE_NONE	= 0,
		DECAYTYPE_INV	= 1,
		DECAYTYPE_INVSQ	= 2
	};

	//! The light information class.
	class LightDescriptor : public ObjectDescriptor
	{
		public:
		// Constructor / Destructor
										LightDescriptor();
		virtual							~LightDescriptor();

		// Parameters
						LType			mLightType;						//!< Light's type
						bool			mIsSpot;						//!< Is the light a spotlight?
						bool			mIsDir;							//!< Is the light a directional?
						MAXPoint		mColor;							//!< Light's color											[Animatable]
						float			mIntensity;						//!< Light's intensity										[Animatable]
						float			mContrast;						//!< Light's contrast										[Animatable]
						float			mDiffuseSoft;					//!< Light's diffuse soft									[Animatable]
						bool			mLightUsed;						//!< Is the light used?
						bool			mAffectDiffuse;					//!< Does the light affect diffuse?
						bool			mAffectSpecular;				//!< Does the light affect specular?
						bool			mUseAttenNear;					//
						bool			mAttenNearDisplay;				//
						bool			mUseAtten;						//!< Is attenuation used?
						bool			mShowAtten;						//
						float			mNearAttenStart;				//!< Near atten start										[Animatable]
						float			mNearAttenEnd;					//!< Near atten end											[Animatable]
						float			mAttenStart;					//!< Atten start											[Animatable]
						float			mAttenEnd;						//!< Atten end (use that as a range for non-dir lights)		[Animatable]
						char			mDecayType;						//!< Light's decay type
						float			mHotSpot;						//!< Light's hotspot										[Animatable]
						float			mFallsize;						//!< Light's falloff										[Animatable]
						float			mAspect;						//!< Light's aspect											[Animatable]
						SpotShp			mSpotShape;						//!< Light's spot shape
						long			mOvershoot;						//!< Light's overshoot
						bool			mConeDisplay;					//
						float			mTDist;							//!< Distance to target										[Animatable]
						long			mShadowType;					//!< Light's shadow type
						long			mAbsMapBias;					//!< Light's absolute map bias
						float			mRayBias;						//!< Raytrace bias											[Animatable]
						float			mMapBias;						//!< Map bias												[Animatable]
						float			mMapRange;						//!< Map range												[Animatable]
						long			mMapSize;						//!< Map size												[Animatable]
						bool			mCastShadows;					//!< Cast shadows or not
						MAXPoint		mShadowColor;					//!< Shadow color											[Animatable]
						bool			mLightAffectsShadow;			//!< Light affects shadow or not
						float			mShadowDensity;					//!< Shadow multiplier										[Animatable]
	};

#endif // __FLX_ADDLIGHT_H__
